<?php
/* -----------------------------------------------------------------
 * 	$Id: checkout.php 1100 2014-06-13 00:43:53Z akausch $
 * 	Copyright (c) 2011-2021 commerce:SEO by Webdesign Erfurt
 * 	http://www.commerce-seo.de
 * ------------------------------------------------------------------
 * 	based on:
 * 	(c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
 * 	(c) 2002-2003 osCommerce - www.oscommerce.com
 * 	(c) 2003     nextcommerce - www.nextcommerce.org
 * 	(c) 2005     xt:Commerce - www.xt-commerce.com
 * 	Released under the GNU General Public License
 * --------------------------------------------------------------- */

include ('includes/application_top.php');
// if(!isset($_SESSION['payment'])) {
// $_SESSION['payment'] = 'moneyorder';
// }
if ($_SERVER['HTTPS'] != 'on' && ENABLE_SSL) {
    xtc_redirect(xtc_href_link(FILENAME_CHECKOUT, '', 'SSL'));
}
$smarty = new Smarty;
require (DIR_FS_CATALOG . 'templates/' . CURRENT_TEMPLATE . '/source/boxes.php');
require_once(DIR_FS_INC . 'xtc_address_label.inc.php');
require_once(DIR_FS_INC . 'xtc_get_address_format_id.inc.php');
require_once(DIR_FS_INC . 'xtc_check_stock.inc.php');
require_once(DIR_FS_INC . 'xtc_count_shipping_modules.inc.php');

require(DIR_WS_CLASSES . 'class.checkout.php');
$checkout = new Checkout;
require_once(DIR_WS_CLASSES . 'class.order_total.php');
require_once(DIR_WS_CLASSES . 'class.order.php');

// Is it an ajax request?
$is_xajax = (strlen($_POST['xajax']) > 4 || strlen($_POST['xjxfun']) > 4 || strlen($_GET['xajax']) > 4 || strlen($_GET['xjxfun']) > 4);

if (!$is_xajax) {
    $_SESSION['cot_gv'] = false;
    unset($_SESSION['stat_luupws']);
}
if (!$is_xajax && $_SESSION['payment'] == 'no_payment') {
    unset($_SESSION['payment']);
}

// check if checkout is allowed
if ($_SESSION['allow_checkout'] == 'false') {
    xtc_redirect(xtc_href_link(FILENAME_SHOPPING_CART));
}

if (CHECKOUT_LOGIN_ALLOW == 'true') {
    if (!isset($_SESSION['customer_id']) && !$is_xajax) {
        $login_content_smarty = new Smarty;
        $create_account_content_smarty = new Smarty;

        //Beta Login im Checkout
        //Login
        $login = new login();
        //Login Smarty holen
        $login_smarty = $login->login_smarty('checkout');
        if (is_array($login_smarty)) {
            foreach ($login_smarty AS $t_key => $t_value) {
                $login_content_smarty->assign($t_key, $t_value);
            }
        }
        //Login checken und ebenfalls Smary holen wegen Antispam
        if (isset($_GET['action']) && ($_GET['action'] == 'process')) {
            $check_login = $login->check_login('checkout');
            if (is_array($check_login)) {
                foreach ($check_login AS $t_key => $t_value) {
                    $login_content_smarty->assign($t_key, $t_value);
                }
            }
        }
        //Extender
        $cseo_login = cseohookfactory::create_object('LoginExtender');
        $cseo_login->set_data('GET', $_GET);
        $cseo_login->set_data('POST', $_POST);
        $cseo_login->proceed();
        $cseo_extender_result_array = $cseo_login->get_response();
        if (is_array($cseo_extender_result_array)) {
            foreach ($cseo_extender_result_array AS $t_key => $t_value) {
                $login_content_smarty->assign($t_key, $t_value);
            }
        }
        //Login end
        //Create Account
        $create_account = new create_account();
        //Create Account Smarty holen
        $create_account_smarty = $create_account->create_account_smarty('checkout');
        if (is_array($create_account_smarty)) {
            foreach ($create_account_smarty AS $t_key => $t_value) {
                $create_account_content_smarty->assign($t_key, $t_value);
            }
        }
        //Extender
        $cseo_create_account = cseohookfactory::create_object('CreateAccountExtender');
        $cseo_create_account->set_data('GET', $_GET);
        $cseo_create_account->set_data('POST', $_POST);
        $cseo_create_account->proceed();
        $cseo_extender_result_array = $cseo_create_account->get_response();
        if (is_array($cseo_extender_result_array)) {
            foreach ($cseo_extender_result_array AS $t_key => $t_value) {
                $create_account_content_smarty->assign($t_key, $t_value);
            }
        }
        //Create Account end
        $create_account_content_smarty->assign('tpl_path', 'templates/base/');
        $create_account_content_smarty->assign('language', $_SESSION['language']);
        $create_account_content = $create_account_content_smarty->fetch(cseo_get_usermod('base/module/create_account.html', USE_TEMPLATE_DEVMODE));
        $smarty->assign('create_account_content', $create_account_content);

        $login_content_smarty->assign('tpl_path', 'templates/base/');
        $login_content_smarty->assign('language', $_SESSION['language']);
        $login_content = $login_content_smarty->fetch(cseo_get_usermod('base/module/login.html', USE_TEMPLATE_DEVMODE));
        $smarty->assign('login_content', $login_content);

        $smarty->assign('checkout_allow', 'false');
    } else {
        $smarty->assign('checkout_allow', 'true');
    }
} elseif ((!isset($_SESSION['customer_id']) && !$is_xajax) && CHECKOUT_LOGIN_ALLOW == 'false') {
// if the customer is not logged on, redirect them to the login page
    if (ACCOUNT_OPTIONS == 'guest') {
        xtc_redirect(xtc_href_link(FILENAME_CREATE_GUEST_ACCOUNT, '', 'SSL'));
    } else {
        xtc_redirect(xtc_href_link(FILENAME_LOGIN, '', 'SSL'));
    }
}

// if there is nothing in the customers cart, redirect them to the shopping cart page
if ($_SESSION['cart']->count_contents() < 1 && !$is_xajax) {
    xtc_redirect(xtc_href_link(FILENAME_SHOPPING_CART));
}

// if no shipping destination address was selected, use the customers own address as default
if (!isset($_SESSION['sendto'])) {
    $_SESSION['sendto'] = $_SESSION['customer_default_address_id'];
} else {
    // verify the selected shipping address
    $check_address = xtc_db_fetch_array(xtc_db_query("SELECT count(*) as total FROM " . TABLE_ADDRESS_BOOK . " WHERE customers_id = '" . (int) $_SESSION['customer_id'] . "' AND address_book_id = '" . (int) $_SESSION['sendto'] . "';"));
    if ($check_address['total'] != '1') {
        $_SESSION['sendto'] = $_SESSION['customer_default_address_id'];
        if (isset($_SESSION['shipping']))
            unset($_SESSION['shipping']);
    }
}

// if no billing destination address was selected, use the customers own address as default
if (!isset($_SESSION['billto'])) {
    $_SESSION['billto'] = $_SESSION['customer_default_address_id'];
} else {
    // verify the selected billing address
    $check_address = xtc_db_fetch_array(xtc_db_query("SELECT count(*) as total FROM " . TABLE_ADDRESS_BOOK . " WHERE customers_id = '" . (int) $_SESSION['customer_id'] . "' AND address_book_id = '" . (int) $_SESSION['billto'] . "';"));
    if ($check_address['total'] != '1') {
        $_SESSION['billto'] = $_SESSION['customer_default_address_id'];
        if (isset($_SESSION['payment']))
            unset($_SESSION['payment']);
    }
}

if (!isset($_SESSION['sendto']) || $_SESSION['sendto'] == '') {
    $_SESSION['sendto'] = $_SESSION['billto'];
}

$order = new order;
if ($order->delivery['country']['iso_code_2'] != '') {
    $_SESSION['delivery_zone'] = $order->delivery['country']['iso_code_2'];
}

if (isset($_SESSION['credit_covers'])) {
    $_SESSION['payment'] = 'no_payment'; // GV Code Start/End ICW added for CREDIT CLASS
}

if (!$is_xajax) {
    if (isset($_SESSION['credit_covers'])) {
        $_SESSION['payment'] = 'no_payment'; // GV Code Start/End ICW added for CREDIT CLASS
    }
    $order_total_modules = new order_total;
    $shipping_modules = new shipping;
    $payment_modules = new payment;

    // SHOW PAYMENT ERROR
    if (isset($_GET['payment_error']) && is_object(${ $_GET['payment_error'] }) && ($error = ${$_GET['payment_error']}->get_error())) {
        $smarty->assign('error', htmlspecialchars($error['error']));
    } elseif (isset($_GET['error_c'])) {
        $smarty->assign('error', htmlspecialchars(defined($_GET['error_c']) ? constant($_GET['error_c']) : $_GET['error_c']));
    } elseif (isset($_GET['error_message'])) {
        $smarty->assign('error', htmlspecialchars(utf8_encode(defined($_GET['error_message']) ? constant($_GET['error_message']) : $_GET['error_message'])));
    }
}
// register a random ID in the session to check throughout the checkout procedure
// against alterations in the shopping cart contents
$_SESSION['cartID'] = $_SESSION['cart']->cartID;

$virtual = $checkout->isVirtual();

$total_weight = $_SESSION['cart']->show_weight();
$total_count = $_SESSION['cart']->count_contents();

// load all enabled shipping modules
if (!$is_xajax) {
    $free_shipping = $checkout->isFreeShipping($order, $xtPrice);
    if ($free_shipping) {
        include (DIR_WS_LANGUAGES . $_SESSION['language'] . '/modules/order_total/ot_shipping.php');
    }
    $quotes = $shipping_modules->quote();
}
if (!$is_xajax) {
    $payment_modules->update_status();
}

// OUTPUT
$breadcrumb->add(NAVBAR_TITLE_1_CHECKOUT);
include('includes/xajax/xajax.checkout.php');
require_once(DIR_WS_INCLUDES . 'header.php');
$module_smarty = new Smarty;
if (defined('VRRL_ACTIVE') && VRRL_ACTIVE == 'true') {
    $show_abandonment_download = false;
    $show_abandonment_service = false;
    $products = $_SESSION['cart']->get_products();
    for ($i = 0, $n = sizeof($products); $i < $n; $i++) {
        if ($products[$i]['product_type'] == '2') {
            if (defined('WITHDRAWAL_DOWNLOAD') && WITHDRAWAL_DOWNLOAD == 'true') {
                $show_abandonment_download = true;
            }
        }
        if ($products[$i]['product_type'] == '3') {
            if (defined('WITHDRAWAL_SERVICE') && WITHDRAWAL_SERVICE == 'true') {
                $show_abandonment_service = true;
            }
        }
    }
    unset($_SESSION['abandonment_download']);
    unset($_SESSION['abandonment_service']);
}
?>

<script type="text/javascript" src="//ajax.googleapis.com/ajax/libs/jquery/1.10.2/jquery.min.js"></script>
<script type="text/javascript">
    var shipping_interval;
    var payment_interval;
    function showFromStart(id) {
        jQuery('#chkt_' + id).show();
        jQuery('#btn_' + id).html('-');
    }
    function check_form_optional(form_name) {
        var form = form_name;

        var firstname = form.elements['firstname'].value;
        var lastname = form.elements['lastname'].value;
        var street_address = form.elements['street_address'].value;

        if (firstname == '' && lastname == '' && street_address == '') {
            return true;
        } else {
            return check_form(form_name);
        }
    }

    function checkout_laws() {
        var chkt_agb_error = '';
        var chkt_revocation_error = '';
        var chkt_revocation_download_error = '';
        var chkt_revocation_service_error = '';
        var chkt_dsg_error = '';
<?php if (DISPLAY_CONDITIONS_ON_CHECKOUT == 'true' && CHECKOUT_CHECKBOX_AGB == 'true') { ?>
            if (!document.getElementById('checkout').conditions.checked) {
                chkt_agb_error += '<?php echo CHECKOUT_ERROR_CONDITIONS; ?>';
            }
<?php } ?>
<?php if (DISPLAY_REVOCATION_ON_CHECKOUT == 'true' && CHECKOUT_CHECKBOX_REVOCATION == 'true') { ?>
            if (!document.getElementById('checkout').revocation.checked) {
                chkt_revocation_error += '<?php echo CHECKOUT_ERROR_REVOCATION; ?>';
            }
<?php } ?>
<?php if ($show_abandonment_download) { ?>
            if (!document.getElementById('checkout').revocationdownload.checked) {
                chkt_revocation_download_error += '<?php echo CHECKOUT_ERROR_REVOCATION_DOWNLOAD; ?>';
            }
<?php } ?>
<?php if ($show_abandonment_service) { ?>
            if (!document.getElementById('checkout').revocationservice.checked) {
                chkt_revocation_service_error += '<?php echo CHECKOUT_ERROR_REVOCATION_SERVICE; ?>';
            }
<?php } ?>

<?php if (DISPLAY_DATENSCHUTZ_ON_CHECKOUT == 'true' && CHECKOUT_CHECKBOX_DSG == 'true') { ?>
            if (!document.getElementById('checkout').dsg.checked) {
                chkt_dsg_error += '<?php echo CHECKOUT_ERROR_DSG; ?>';
            }
<?php } ?>

        return {agb_error: chkt_agb_error, revocation_error: chkt_revocation_error, revocation_error_download: chkt_revocation_download_error, revocation_error_service: chkt_revocation_service_error, dsg_error: chkt_dsg_error};
    }

    function checkout() {
        document.getElementById('checkout_error_agb').innerHTML = '';
        document.getElementById('checkout_error_agb').style.display = 'none';
        document.getElementById('checkout_error_revocation').innerHTML = '';
        document.getElementById('checkout_error_revocation').style.display = 'none';
        document.getElementById('checkout_error_dsg').innerHTML = '';
        document.getElementById('checkout_error_dsg').style.display = 'none';
        document.getElementById('checkout_error_payment').innerHTML = '';
        document.getElementById('checkout_error_payment').style.display = 'none';
        document.getElementById('checkout_error_shipping').innerHTML = '';
        document.getElementById('checkout_error_shipping').style.display = 'none';
        document.getElementById('checkout_please_wait').innerHTML = '';
        document.getElementById('checkout_please_wait').style.display = 'none';

        var checkout_laws_response = checkout_laws();
        if (checkout_laws_response.agb_error != '' || checkout_laws_response.revocation_error != '' || checkout_laws_response.revocation_error_download != '' || checkout_laws_response.revocation_error_service != '' || checkout_laws_response.dsg_error != '') {
            if (checkout_laws_response.agb_error != '') {
                document.getElementById('checkout_error_agb').innerHTML = checkout_laws_response.agb_error;
                document.getElementById('checkout_error_agb').style.display = '';
            }
            if (checkout_laws_response.dsg_error != '') {
                document.getElementById('checkout_error_dsg').innerHTML = checkout_laws_response.dsg_error;
                document.getElementById('checkout_error_dsg').style.display = '';
            }
            if (checkout_laws_response.revocation_error != '') {
                document.getElementById('checkout_error_revocation').innerHTML = checkout_laws_response.revocation_error;
                document.getElementById('checkout_error_revocation').style.display = '';
            }
            if (checkout_laws_response.revocation_error_download != '') {
                document.getElementById('checkout_error_revocation').innerHTML = checkout_laws_response.revocation_error_download;
                document.getElementById('checkout_error_revocation').style.display = '';
            }
            if (checkout_laws_response.revocation_error_service != '') {
                document.getElementById('checkout_error_revocation').innerHTML = checkout_laws_response.revocation_error_service;
                document.getElementById('checkout_error_revocation').style.display = '';
            }
        } else {
            document.getElementById('checkout_please_wait').style.display = '';
            document.getElementById('checkout_please_wait').innerHTML = '<?php echo CHECKOUT_PLEASE_WAIT; ?>';
            xajax_checkout_check();
        }
    }
<?php if (DISPLAY_REVOCATION_ON_CHECKOUT == 'true') { ?>
        function hitRevocation() {
            if (document.getElementById('checkout').revocation.checked) {
                document.getElementById('checkout_error_revocation').innerHTML = '';
                document.getElementById('checkout_error_revocation').style.display = 'none';
            }
        }
<?php } ?>
<?php if ($show_abandonment_download) { ?>
        function hitRevocationDownload() {
            if (document.getElementById('checkout').revocationdownload.checked) {
                document.getElementById('checkout_error_revocation').innerHTML = '';
                document.getElementById('checkout_error_revocation').style.display = 'none';
            }
        }
<?php } ?>
<?php if ($show_abandonment_service) { ?>
        function hitRevocationService() {
            if (document.getElementById('checkout').revocationservice.checked) {
                document.getElementById('checkout_error_revocation').innerHTML = '';
                document.getElementById('checkout_error_revocation').style.display = 'none';
            }
        }
<?php } ?>
<?php if (DISPLAY_DATENSCHUTZ_ON_CHECKOUT == 'true') { ?>
        function hitDSG() {
            if (document.getElementById('checkout').dsg.checked) {
                document.getElementById('checkout_error_dsg').innerHTML = '';
                document.getElementById('checkout_error_dsg').style.display = 'none';
            }
        }
<?php } ?>
<?php if (DISPLAY_CONDITIONS_ON_CHECKOUT == 'true') { ?>
        function hitAGB() {
            if (document.getElementById('checkout').conditions.checked) {
                document.getElementById('checkout_error_agb').innerHTML = '';
                document.getElementById('checkout_error_agb').style.display = 'none';
            }
        }
<?php } ?>


    function slideInOrOut(id) {
        jQuery('#chkt_' + id).slideToggle('slow');

        if (jQuery('#chkt_' + id).attr("display") == "none")
            jQuery('#btn_' + id).html('+');
        else
            jQuery('#btn_' + id).html('-');
    }

    function paymentShowOrHide(pmodule) {
        if (pmodule == 'pmodule_luupws' && document.getElementById('pmodule_luupws').innerHTML == '') {
            pmodule = 'pmodule_luupws2';
        }
        var modules = document.getElementById('payments').getElementsByTagName('tbody');
        try {
            for (var y = 0; y < modules.length; y++) {
                if (modules[y].id.indexOf('pmodule') != -1) {
                    if (modules[y].id != pmodule) {
                        modules[y].style.display = 'none';
                    } else {
                        modules[y].style.display = '';
                    }
                }
            }
        } catch (e) {
            // do nothing
        } finally {
            document.getElementById('payment_module_error').innerHTML = '&nbsp;';
            showFromStart('payment_modules');
            clearInterval(payment_interval);
            payment_interval = setInterval("blinkBlink(document.getElementById('button_save_payment'))", 400);
        }
    }

    function shippingShowOrHide(smodule) {
        document.getElementById('shipping_module_error').innerHTML = '&nbsp;';

        showFromStart('shipping_modules');
        clearInterval(shipping_interval);
        shipping_interval = setInterval("blinkBlink(document.getElementById('button_save_shipping'))", 500);
    }

    function activateShipping(which) {
        try {
            for (var y = 0; y < smodule_length; y++) {
                if (which != ('srow' + y)) {
                    document.getElementById('srow' + y).className = 'moduleRow';
                } else {
                    document.getElementById('srow' + y).className = 'moduleRowSelected';
                }
            }
        } catch (e) {
            // do nothing
        } finally {
            if (which != 'no') {
                document.getElementById('shipping_module_error').innerHTML = '';
                document.getElementById('checkout_error_shipping').innerHTML = '';
                document.getElementById('checkout_error_shipping').style.display = 'none';
            }
            showFromStart('shipping_modules');
        }
    }

    function activatePayment(which) {

        try {
            var modules = document.getElementById('payments').getElementsByTagName('tr');
            for (var y = 0; y < modules.length; y++) {
                if (modules[y].id.indexOf('prow') != -1) {
                    if (modules[y].id != which) {
                        modules[y].className = 'moduleRow';
                    } else {
                        modules[y].className = 'moduleRowSelected';

                    }
                }
            }
        } catch (e) {
            // do nothing
        } finally {
            if (which != 'no') {
                document.getElementById('payment_module_error').innerHTML = '';
                document.getElementById('checkout_error_payment').innerHTML = '';
                document.getElementById('checkout_error_payment').style.display = 'none';
            }
            showFromStart('payment_modules');
        }
    }

    function updateProducts(id, math) {
        if (math == 'minus' && document.getElementById('qty_' + id).innerHTML == 1) {
            removeProduct(id);
        } else if (math == 'plus' && document.getElementById('qty_' + id).innerHTML == <?php echo MAX_PRODUCTS_QTY ?>) {
            // do nothing
        } else {
            document.getElementById('loader_products').style.display = '';
            xajax_updateProducts(id, math);
        }
    }

    function updateAttributes(html_id, html_aid) {
        document.getElementById('loader_products').style.display = '';
        document.getElementById(html_id).disabled = true;
        xajax_updateAttributes(html_id, html_aid, document.getElementById(html_id).value);
    }

    function removeProduct(id) {
        if (confirm('<?php echo CHECKOUT_REMOVE_CONFIRM; ?>')) {
            document.getElementById('loader_products').style.display = '';
            makeInactive(document.getElementById('product_' + id));
            xajax_removeProduct(id);
        }
    }

    function useGV(which) {
        document.getElementById('loader_payment_modules').style.display = '';
        if (which.checked) {
            xajax_useGV(1);
        } else {
            xajax_useGV(0);
        }
    }

    function updatePaymentModule() {
        var something_checked = false;
        var dropdown = true;
        if (document.getElementById('form_payment_modules').payment.length > 1 && (typeof document.getElementById('form_payment_modules').payment.nodeName == 'undefined' ? true : false)) {
            dropdown = false;
            for (var o = 0; o < document.getElementById('form_payment_modules').payment.length; o++) {
                if (document.getElementById('form_payment_modules').payment[o].checked) {
                    something_checked = true;
                    break;
                }
            }
        }
        if ((typeof document.getElementById('form_payment_modules').payment.nodeName == 'undefined' ? false : true) && document.getElementById('form_payment_modules').payment.value.length >= 2 && document.getElementById('form_payment_modules').payment.value != 'no') {
            something_checked = true;
        }


        if (something_checked) {
            xajax_updatePaymentModule(xajax.getFormValues('form_payment_modules'));
            document.getElementById('payment_module_error').innerHTML = '';
            document.getElementById('loader_payment_modules').style.display = '';
            makeInactive(document.getElementById('form_payment_modules'));
        } else {
            document.getElementById('payment_module_error').innerHTML = '<?php echo CHECKOUT_NO_PAYMENT_MODULE_SELECTED; ?>';
        }
        showFromStart('payment_modules');
    }

    function updateShippingModule() {
        var something_checked = false;
        var dropdown = true;
        if (document.getElementById('form_shipping_modules').shipping.length > 1 && (typeof document.getElementById('form_shipping_modules').shipping.nodeName == 'undefined' ? true : false)) {
            dropdown = false;
            for (var o = 0; o < document.getElementById('form_shipping_modules').shipping.length; o++) {
                if (document.getElementById('form_shipping_modules').shipping[o].checked) {
                    something_checked = true;
                    break;
                }
            }
        }
        if ((typeof document.getElementById('form_shipping_modules').shipping.nodeName == 'undefined' ? false : true) && document.getElementById('form_shipping_modules').shipping.value.indexOf('_') != -1) {
            something_checked = true;
        }
        if (something_checked) {
            xajax_updateShippingModule(xajax.getFormValues('form_shipping_modules'));
            document.getElementById('shipping_module_error').innerHTML = '';
            document.getElementById('loader_shipping_modules').style.display = '';
            makeInactive(document.getElementById('form_shipping_modules'));
        } else {
            document.getElementById('shipping_module_error').innerHTML = '<?php echo CHECKOUT_NO_SHIPPING_MODULE_SELECTED; ?>';
        }
        showFromStart('shipping_modules');
    }

    function updateAddressBySelect(which, id) {
        document.getElementById('loader_' + which + '_address').style.display = '';
        makeInactive(document.getElementById('chkt_' + which + '_address'));
        xajax_updateAddressBySelect(which, id);

    }

    function editAddress(which) {
        document.getElementById('loader_' + which + '_address').style.display = '';
        xajax_updateAddressSelect(which);
    }

    function cancelAddress(which) {
        document.getElementById(which + '_address_select').style.display = 'none';
        document.getElementById(which + '_address').style.display = '';
        document.getElementById(which + '_address_button_edit').style.display = '';
        document.getElementById(which + '_address_button_save').style.display = 'none';
        showFromStart(which + '_address');
    }

    function updateAddress(which) {
        document.getElementById('loader_' + which + '_address').style.display = '';
        xajax_updateAddress(xajax.getFormValues('form_' + which + '_address'), which);
        makeInactive(document.getElementById(which + '_address_select'));
    }

    function updateStates(cid, which_form) {
        document.getElementById('loader_' + which_form.id.substr(5)).style.display = '';
        xajax_updateStates(cid, which_form.id);
    }

    function showSelect(select_id) {
        jQuery('#atta_' + select_id).hide();
        jQuery('#attd_' + select_id).show();
        document.getElementById('attd_' + select_id).getElementsByTagName('select')[0].disabled = false;
        showFromStart('products');
    }

    function makeInactive(form_name) {
        var get_select = form_name.getElementsByTagName('select');
        for (var i = 0; i < get_select.length; i++) {
            get_select[i].disabled = true;
        }
        var get_input = form_name.getElementsByTagName('input');
        for (var i = 0; i < get_input.length; i++) {
            get_input[i].disabled = true;
        }
    }

    function makeActive(form_name) {
        var get_select = form_name.getElementsByTagName('select');
        for (var i = 0; i < get_select.length; i++) {
            get_select[i].disabled = false;
        }
        var get_input = form_name.getElementsByTagName('input');
        for (var i = 0; i < get_input.length; i++) {
            get_input[i].disabled = false;
        }
    }

    function updateBecauseItsVirtual() {
        document.getElementById('virtual_address').style.display = '';
        document.getElementById('not_virtual_address').style.display = 'none';
        document.getElementById('virtual_modules').style.display = '';
        document.getElementById('free_shipping_modules').style.display = 'none';
        document.getElementById('not_virtual_modules').style.display = 'none';
        document.getElementById('checkout_error_shipping').style.display = 'none';
        document.getElementById('checkout_error_shipping').innerHTML = '';
        if (document.getElementById('btn_shipping_address').innerHTML == '-')
            showFromStart('shipping_address');
        if (document.getElementById('btn_shipping_modules').innerHTML == '-')
            showFromStart('shipping_modules');
    }

    function updateBecauseItsFreeShipping() {
        document.getElementById('free_shipping_modules').style.display = '';
        document.getElementById('not_virtual_modules').style.display = 'none';
        if (document.getElementById('btn_shipping_modules').innerHTML == '-')
            showFromStart('shipping_modules');
    }

    function updateBecauseItsNotFreeShipping() {
        document.getElementById('free_shipping_modules').style.display = 'none';
        document.getElementById('not_virtual_modules').style.display = '';
        if (document.getElementById('btn_shipping_modules').innerHTML == '-')
            showFromStart('shipping_modules');
    }

    function blinkBlink(button) {

        try {
            var fix = button.id.split('_');

            var form = document.getElementById('form_' + fix[2] + '_modules');
            if (form[fix[2]].value != 'no') {
                if (button.style.opacity == 0.3 || button.style.filter == 'alpha(opacity=30)') {
                    button.style.opacity = 1;
                    button.style.filter = 'alpha(opacity=100)';
                } else {
                    button.style.opacity = 0.3;
                    button.style.filter = 'alpha(opacity=30)';
                }
            } else {
                clearBlinkBlink(fix[2]);
            }

        } catch (e) {
            // do nothing
        }
    }

    function clearBlinkBlink(which) {
        try {
            if (which == 'payment') {
                clearInterval(payment_interval);
                document.getElementById('button_save_payment').style.opacity = 1;
                document.getElementById('button_save_payment').style.filter = 'alpha(opacity=100)';
            } else {
                clearInterval(shipping_interval);
                document.getElementById('button_save_shipping').style.opacity = 1;
                document.getElementById('button_save_shipping').style.filter = 'alpha(opacity=100)';
            }
        } catch (e) {
            // do nothing
        }
    }
</script>


<?php
// PAYMENT STUFF
if ($order->info['total'] <= 0) {
    $gv_cover = 'true';
}

$cot_gv_stat = $_SESSION['cot_gv'] ? 1 : 0;

// Disable payment/shipping modules
if (!empty($_SESSION['shipping']['id']) && $_SESSION['shipping']['id'] != 'selfpickup_selfpickup' && !$is_xajax) {
    if (is_object($GLOBALS['cash'])) {
        $GLOBALS['cash']->enabled = false;
    }
}
if (!empty($_SESSION['shipping']['id']) && $_SESSION['shipping']['id'] == 'selfpickup_selfpickup' && !$is_xajax) {
    if (is_object($GLOBALS['cod'])) {
        $GLOBALS['cod']->enabled = false;
    }
}

// SHIPPING STUFF
if (!$is_xajax) {
    $shipping_block = $checkout->getShippingBlock($xtPrice);
}
if (in_array('productsshipping.php', $check) || sizeof($check) <= 1) {
    $smarty->assign('ONE_SHIPPING', ' dn');
}
$order = new order;
if (!$is_xajax) {
    $payment_block = $checkout->getPaymentBlock($xtPrice, $payment_modules);
}
$check = explode(';', MODULE_PAYMENT_INSTALLED);
if (sizeof($check) <= 1) {
    $smarty->assign('ONE_PAYMENT', ' dn');
}

// Stock Check
$any_out_of_stock = false;
if (STOCK_CHECK == 'true') {
    for ($i = 0, $n = sizeof($order->products); $i < $n; $i++) {
        if (xtc_check_stock($order->products[$i]['id'], $order->products[$i]['qty']))
            $any_out_of_stock = true;
    }
    // Out of Stock
    if ((STOCK_ALLOW_CHECKOUT != 'true') && ($any_out_of_stock == true))
        xtc_redirect(xtc_href_link(FILENAME_SHOPPING_CART));
}

if (!$is_xajax) {
    $order = new order;
    $order_total_modules = new order_total();
    $order_total_modules->collect_posts();
    $order_total_modules->pre_confirmation_check();
    $order_total_modules->process();
    if (ACTIVATE_GIFT_SYSTEM == 'true') {
        $module_gift = $order_total_modules->credit_selection();
    }
}
// Which modules should be opened?
$smarty->assign('SHOW_STAT_PAYMENT_ADDRESS', $checkout->getStat('payment_address'));
$smarty->assign('SHOW_STAT_SHIPPING_ADDRESS', $checkout->getStat('shipping_address'));
$smarty->assign('SHOW_STAT_PAYMENT_MODULES', $checkout->getStat('payment_modules'));
$smarty->assign('SHOW_STAT_SHIPPING_MODULES', $checkout->getStat('shipping_modules'));
$smarty->assign('SHOW_STAT_COMMENTS', $checkout->getStat('comments'));
$smarty->assign('SHOW_STAT_PRODUCTS', $checkout->getStat('products'));
$smarty->assign('SHOW_STAT_AGB', $checkout->getStat('agb'));
$smarty->assign('SHOW_STAT_DSG', $checkout->getStat('dsg'));
$smarty->assign('SHOW_STAT_REVOCATION', $checkout->getStat('revocation'));

// FORM
$smarty->assign('FORM_ACTION', xtc_draw_form('checkout', $checkout->getFormUrl(), 'post', 'onSubmit="return checkout();"'));
$smarty->assign('FORM_END', '</form>');

// IP
$smarty->assign('CUSTOMERS_IP', $checkout->getIp());

// SHIPPING MODULES
$no_shippings = xtc_not_null(MODULE_SHIPPING_INSTALLED) ? 0 : 1;
$smarty->assign('NO_SHIPPINGS', $no_shippings);
$smarty->assign('FORM_ACTION_SHIPPING_MODULES', xtc_draw_form('form_shipping_modules', '', 'post', ''));
$smarty->assign('SHIPPING_BLOCK', $shipping_block);
$smarty->assign('BUTTON_SAVE_SHIPPING_MODULE', $checkout->getSaveModuleButton('shipping'));
$smarty->assign('FREE_SHIPPING', $free_shipping ? 1 : 0);
$smarty->assign('FREE_SHIPPING_DESCRIPTION', sprintf(FREE_SHIPPING_DESCRIPTION, $xtPrice->xtcFormat(MODULE_ORDER_TOTAL_SHIPPING_FREE_SHIPPING_OVER, true, 0, true)) . xtc_draw_hidden_field('shipping', 'free_free'));
$smarty->assign('FREE_SHIPPING_ICON', $quotes[$i]['icon']);


// PAYMENT MODULES
$no_payments = xtc_not_null(MODULE_PAYMENT_INSTALLED) ? 0 : 1;
$smarty->assign('NO_PAYMENTS', $no_payments);
$smarty->assign('FORM_ACTION_PAYMENT_MODULES', xtc_draw_form('form_payment_modules', '', 'post', ''));
$smarty->assign('PAYMENT_BLOCK', $payment_block);
$smarty->assign('GV_COVER', $gv_cover);
$smarty->assign('module_gift', $module_gift);
$smarty->assign('BUTTON_SAVE_PAYMENT_MODULE', $checkout->getSaveModuleButton('payment'));

// SHIPPING ADDRESS
$smarty->assign('VIRTUAL', $virtual);
$smarty->assign('TEXT_VIRTUAL', CHECKOUT_TEXT_VIRTUAL);
$smarty->assign('BUTTON_EDIT_SHIPPING_ADDRESS', $checkout->getEditAddressButton('shipping'));
$smarty->assign('BUTTON_BACK_SHIPPING_ADDRESS', $checkout->getBackButton('shipping'));
$smarty->assign('BUTTON_SAVE_SHIPPING_ADDRESS', $checkout->getSaveAddressButton('shipping'));
$smarty->assign('SHIPPING_ADDRESS_LABEL', xtc_address_label($_SESSION['customer_id'], $_SESSION['sendto'], true, ' ', '<br />'));
$smarty->assign('FORM_ACTION_SHIPPING_ADDRESS', xtc_draw_form('form_shipping_address', '', 'post', ''));

// PAYMENT ADDRESS
$smarty->assign('BUTTON_EDIT_PAYMENT_ADDRESS', $checkout->getEditAddressButton('payment'));
$smarty->assign('BUTTON_BACK_PAYMENT_ADDRESS', $checkout->getBackButton('payment'));
$smarty->assign('BUTTON_SAVE_PAYMENT_ADDRESS', $checkout->getSaveAddressButton('payment'));
$smarty->assign('PAYMENT_ADDRESS_LABEL', xtc_address_label($_SESSION['customer_id'], $_SESSION['billto'], true, ' ', '<br />'));
$smarty->assign('FORM_ACTION_PAYMENT_ADDRESS', xtc_draw_form('form_payment_address', '', 'post', ''));

// BOTH
require (DIR_WS_MODULES . 'checkout_new_address.php');
$smarty->assign('ADDRESS_NEW_POSSIBLE', $checkout->newAddressPossible());

// PRODUCTS
$smarty->assign('PRODUCTS_BLOCK', $checkout->getProducts());
$smarty->assign('PRODUCTS_HOW_MUCH', $_SESSION['cart']->count_contents());

// COMMENTS
$smarty->assign('COMMENTS', xtc_draw_textarea_field('comments', 'soft', '60', '4', $_SESSION['comments'], 'style="width:99.8%"') . xtc_draw_hidden_field('comments_added', 'YES'));

// AGB
$smarty->assign('AGB', $checkout->getAGB('text'));
$smarty->assign('AGB_link', $checkout->getAGB('link'));
$smarty->assign('AGB_checkbox', $checkout->getAGB('checkbox'));
$smarty->assign('AGB_stat', $checkout->getAGB('stat'));
if (CHECKOUT_CHECKBOX_AGB == 'true') {
    $smarty->assign('AGB_CHECKBOX', 'true');
}

// REVOCATION
$smarty->assign('REVOCATION', $checkout->getRevocation('text'));
$smarty->assign('REVOCATION_link', $checkout->getRevocation('link'));
$smarty->assign('REVOCATION_stat', $checkout->getRevocation('stat'));
$smarty->assign('REVOCATION_checkbox', $checkout->getRevocation('checkbox'));
if (CHECKOUT_CHECKBOX_REVOCATION == 'true') {
    $smarty->assign('REVOCATION_CHECKBOX', 'true');
}

// Datenschutz
$smarty->assign('DSG', $checkout->getDSG('text'));
$smarty->assign('DSG_link', $checkout->getDSG('link'));
$smarty->assign('DSG_stat', $checkout->getDSG('stat'));
$smarty->assign('DSG_checkbox', $checkout->getDSG('checkbox'));
if (CHECKOUT_CHECKBOX_DSG == 'true') {
    $smarty->assign('DSG_CHECKBOX', 'true');
}
// Zusatztext
$smarty->assign('SZI', $checkout->getSZI('text'));

// HIDDEN
$smarty->assign('HIDDEN_XAJAX', xtc_draw_hidden_field('checkout_xajax', '1'));
if (is_object($GLOBALS[$_SESSION['payment']])) {
    $smarty->assign('HIDDEN_PAYMENT', $GLOBALS[$_SESSION['payment']]->process_button());
}

// BUTTONS
$smarty->assign('BUTTON_ORDER', '<a href="javascript:void(0)">' . cseo_wk_image_button('button_confirm_order.gif', IMAGE_BUTTON_CONFIRM_ORDER, 'onclick="checkout();"') . '</a>');
$smarty->assign('BUTTON_ORDER_BACK', '<a href="javascript:void(0)">' . xtc_image_button('button_back.gif', IMAGE_BUTTON_BACK, 'onclick="javascript:history.back();"') . '</a>');

// TOTAL
if (!$is_xajax) {
    $smarty->assign('ORDER_TOTAL', $checkout->getTotalBlock($order, $order_total_modules, $xtPrice));
}

//WR Formular
if (WRCHECKOUT == 'true' && WRCHECKOUTFILE != '') {
    $smarty->assign('WRCHECKOUTFILE', '<a href="' . xtc_href_link(WRCHECKOUTFILE, '', 'SSL') . '">' . xtc_image('images/button_pdf.gif') . BUTTON_WITHDRAWAL_PDF_DOWNLOAD . '</a>');
}

if ($show_abandonment_download) {
    $smarty->assign('SHOW_ABANDONMENT_DOWNLOAD', 'true');
    $smarty->assign('REVOCATION_DOWNLOAD_checkbox', $checkout->getRevocationDownload('checkbox'));
}
if ($show_abandonment_service) {
    $smarty->assign('SHOW_ABANDONMENT_SERVICE', 'true');
    $smarty->assign('REVOCATION_SERVICE_checkbox', $checkout->getRevocationService('checkbox'));
}


// MAIN
$smarty->assign('SORTING', $checkout->getSorting());
$smarty->assign('DEVMODE', USE_TEMPLATE_DEVMODE);
$smarty->assign('checkout', 'true');
$smarty->assign('language', $_SESSION['language']);
$smarty->caching = false;

$cseo_checkout = cseohookfactory::create_object('CheckoutExtender');
$cseo_checkout->set_data('GET', $_GET);
$cseo_checkout->set_data('POST', $_POST);
$cseo_checkout->proceed();
$cseo_extender_result_array = $cseo_checkout->get_response();
if (is_array($cseo_extender_result_array)) {
    foreach ($cseo_extender_result_array AS $t_key => $t_value) {
        $smarty->assign($t_key, $t_value);
    }
}

if (file_exists(DIR_WS_INCLUDES . 'addons/checkout_addon.php')) {
    include (DIR_WS_INCLUDES . 'addons/checkout_addon.php');
}

$main_content = $smarty->fetch(cseo_get_usermod('base/module/checkout.html', USE_TEMPLATE_DEVMODE));

$smarty->assign('main_content', $main_content);

$smarty->display(cseo_get_usermod(CURRENT_TEMPLATE . '/index.html', USE_TEMPLATE_DEVMODE));
include ('includes/application_bottom.php');
